definition module StdMenuElementClass


//	********************************************************************************
//	Clean Standard Object I/O library, version 1.1
//	
//	StdMenuElementClass defines the standard set of menu element instances.
//	********************************************************************************


import	StdMenuDef
from	menuhandle	import MenuElementState


class MenuElements m
where
	menuElementToHandles	:: !(m .ls .ps) -> [MenuElementState .ls .ps]
	getMenuElementType		::  (m .ls .ps) -> MenuElementType

instance MenuElements (AddLS	m)	| MenuElements m	// getMenuElementType==""
instance MenuElements (NewLS	m)	| MenuElements m	// getMenuElementType==""
instance MenuElements (ListLS	m)	| MenuElements m	// getMenuElementType==""
instance MenuElements NilLS								// getMenuElementType==""
instance MenuElements ((:+:) m1 m2)	| MenuElements m1
									& MenuElements m2	// getMenuElementType==""
instance MenuElements (SubMenu	m)	| MenuElements m
instance MenuElements RadioMenu
instance MenuElements MenuItem
instance MenuElements MenuSeparator
